#version 140
#extension GL_EXT_gpu_shader4 : enable
//Nano TubesMod01.fsh
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
//https://www.shadertoy.com/view/lslGRH
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed


#define iTime u_Elapsed*0.3090234
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )


//#define iChannel0 sampler2D
//#define iChannel1 sampler2D
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


// With tweaks from fernlightning

float rand(vec3 n) {
  n = floor(n);
  return fract(sin((n.x+n.y*1e2+n.z*1e4)*1e-4)*1e5);
}

// .x is distance, .y = colour
vec2 map( vec3 p ) {
	const float RADIUS = 0.25;

	// cylinder
	vec3 f = fract( p ) - 0.5;
	float d = length( f.xy );
        float cr = rand( p );
	float cd = d - cr*RADIUS;

	// end - calc (rand) radius at more stable pos
	p.z -= 0.5;
	float rr = rand( p );
	float rn = d - rr*RADIUS;
    float rm = abs( fract( p.z ) - 0.5 );  // offset so at end of cylinder
       
	float rd = sqrt( rn*rn + rm*rm ); // end with ring

	return (cd < rd) ?  vec2( cd, cr ) : vec2( rd, rr ); // min
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    vec2 pos = (gl_FragCoord.xy*2.0 - iResolution.xy) / iResolution.y;
    vec3 camPos = vec3(cos(iTime*0.3), sin(iTime*0.3), 3.5);
    vec3 camTarget = vec3(0.0, 0.0, .0);

    vec3 camDir = normalize(camTarget-camPos);
    vec3 camUp  = normalize(vec3(0.0, 1.0, 0.0));
    vec3 camSide = cross(camDir, camUp);
    float focus = 1.8;

    vec3 rayDir = normalize(camSide*pos.x + camUp*pos.y + camDir*focus);
    vec3 ray = camPos;
    float m = 0.32;
    vec2 d;
    float total_d = 0.;
    const int MAX_MARCH = 100;
    const float MAX_DISTANCE = 100.0;
    for(int i=0; i<MAX_MARCH; ++i) {
        d = map(ray-vec3(0.,0.,iTime/2.));
        total_d += d.x;
        ray += rayDir * d.x;
        m += 1.0;
        if(abs(d.x)<0.01) { break; }
        if(total_d>MAX_DISTANCE) { total_d=MAX_DISTANCE; break; }
    }

    float c = (total_d)*0.0001;
    vec4 result = vec4( 1.0-vec3(c, c, c) - vec3(0.025, 0.025, 0.02)*m*0.8, 1.0 );
    gl_FragColor = result*d.y;
}
